/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.sfp.surveillance;

import com.ibm.hsc.common.util.PartitionInfo;
import com.ibm.hsc.sfp.surveillance.SurveillanceEventType;
import com.ibm.hsc.sfp.surveillance.SurveillancePartitionConnectionState;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.UnsignedInt8;

public class SurveillancePartitionState {
    public static final short CIM_PARTITION_STATE_RUNNING = 8;
    private UnsignedInt8 cimState;
    private boolean surveillanceEnabledSetting;
    private boolean inPartitionMode;
    private SurveillancePartitionConnectionState stableConnectionState;
    private SurveillanceEventType lastEventType;
    private String userName;
    private boolean cimInfoValid;
    private boolean hasBeenConnected;
    private boolean notYetConnectedEventHasBeenQueued;

    SurveillancePartitionState(UnsignedInt8 unsignedInt8, boolean bl, SurveillancePartitionConnectionState surveillancePartitionConnectionState, SurveillanceEventType surveillanceEventType, boolean bl2, String string) {
        this.cimState = unsignedInt8;
        this.surveillanceEnabledSetting = bl;
        this.stableConnectionState = surveillancePartitionConnectionState;
        this.lastEventType = surveillanceEventType;
        this.inPartitionMode = bl2;
        this.userName = string;
        this.cimInfoValid = true;
        this.notYetConnectedEventHasBeenQueued = false;
        this.hasBeenConnected = surveillancePartitionConnectionState != null && surveillancePartitionConnectionState.equals(SurveillancePartitionConnectionState.CONNECTED);
    }

    SurveillancePartitionState(SurveillancePartitionConnectionState surveillancePartitionConnectionState, SurveillanceEventType surveillanceEventType) {
        this.stableConnectionState = surveillancePartitionConnectionState;
        this.lastEventType = surveillanceEventType;
        this.cimInfoValid = false;
        this.notYetConnectedEventHasBeenQueued = false;
        this.hasBeenConnected = surveillancePartitionConnectionState != null && surveillancePartitionConnectionState.equals(SurveillancePartitionConnectionState.CONNECTED);
    }

    public static void main(String[] stringArray) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("lastEventType = ");
        if (this.lastEventType != null) {
            stringBuffer.append(this.lastEventType.toString());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(", ");
        stringBuffer.append("stableConnectionState = ");
        if (this.stableConnectionState != null) {
            stringBuffer.append(this.stableConnectionState.toString());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(", ");
        stringBuffer.append("hasBeenConnected = ");
        stringBuffer.append(String.valueOf(this.hasBeenConnected));
        stringBuffer.append(", ");
        stringBuffer.append("cimInfoValid = ");
        stringBuffer.append(String.valueOf(this.cimInfoValid));
        stringBuffer.append(", ");
        stringBuffer.append("userName = ");
        if (this.userName != null) {
            stringBuffer.append(this.userName);
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(", ");
        stringBuffer.append("cimState = ");
        if (this.cimState != null) {
            stringBuffer.append(this.cimState.toString());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(", ");
        stringBuffer.append("inPartitionMode = ");
        stringBuffer.append(String.valueOf(this.inPartitionMode));
        stringBuffer.append(", ");
        stringBuffer.append("surveillanceEnabledSetting = ");
        stringBuffer.append(String.valueOf(this.surveillanceEnabledSetting));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    synchronized SurveillancePartitionConnectionState getStableConnectionState() {
        return this.stableConnectionState;
    }

    boolean getHasQueuedNYC() {
        return this.notYetConnectedEventHasBeenQueued;
    }

    void setHasQueuedNYC(boolean bl) {
        this.notYetConnectedEventHasBeenQueued = bl;
    }

    synchronized SurveillanceEventType getLastEventType() {
        return this.lastEventType;
    }

    synchronized String getUserName() throws CIMException {
        if (this.cimInfoValid) {
            return this.userName;
        }
        throw new CIMException("");
    }

    synchronized boolean isSurveillanceEnabled() throws CIMException {
        if (this.cimInfoValid) {
            return this.surveillanceEnabledSetting;
        }
        throw new CIMException("");
    }

    synchronized boolean isInPartitionMode() throws CIMException {
        if (this.cimInfoValid) {
            return this.inPartitionMode;
        }
        throw new CIMException("");
    }

    synchronized boolean isRunning() throws CIMException {
        if (this.cimInfoValid) {
            return this.cimState.shortValue() == 8;
        }
        throw new CIMException("");
    }

    synchronized boolean hasBeenConnected() {
        return this.hasBeenConnected;
    }

    synchronized void setLastEventType(SurveillanceEventType surveillanceEventType) {
        this.lastEventType = surveillanceEventType;
    }

    synchronized void setStableConnectionState(SurveillancePartitionConnectionState surveillancePartitionConnectionState) {
        this.stableConnectionState = surveillancePartitionConnectionState;
        if (!this.hasBeenConnected && surveillancePartitionConnectionState != null && surveillancePartitionConnectionState.equals(SurveillancePartitionConnectionState.CONNECTED)) {
            this.hasBeenConnected = true;
        }
    }

    synchronized void setCIMInfo(PartitionInfo partitionInfo) {
        this.cimState = partitionInfo.getState();
        this.surveillanceEnabledSetting = partitionInfo.getSurveillanceSetting();
        this.inPartitionMode = partitionInfo.getIsInPartitionMode();
        this.userName = partitionInfo.getUserName();
        this.cimInfoValid = true;
    }

    UnsignedInt8 getCIMState() {
        return this.cimState;
    }
}

